#!/bin/sh

emgdb=emg
emguser=emguser
emgpasswd=secret
emghost=127.0.0.1
emgport=3306

while true
do
	case "$1" in
	-host)
		emghost=$2
		shift
		;;
	-port)
		emgport=$2
		shift
		;;
	-user)
		emguser=$2
		shift
		;;
	-password)
		emgpasswd=$2
		shift
		;;
	*)
		break
		;;
	esac
	shift
done

fixipvalue()
{
	value=`echo $value | awk -F '.' '{ v=0.0+$1; v=v*256+$2; v=v*256+$3; v=v*256+$4; printf "%d", v }'`
}

editaccess()
{
	while true; do
		mysql -u$emguser -p$emgpasswd -h$emghost -P$emgport $emgdb << EOF
select useraccessid,connector,ipaddress,ipwidth from emguseraccess where useraccessid=$uaid\G
EOF
		cat << EOF
Enter name of attribute to change, 'del' to delete the entry,
or 'q' to go back.
EOF
		read uaatt
		case $uaatt in
			q)
				return
				;;
			del)
				mysql -u$emguser -p$emgpasswd -h$emghost -P$emgport $emgdb << EOF
delete from emguseraccess where useraccessid=$uaid;
EOF
				return
				;;
			*)
				cat << EOF
Enter new value for $uaatt.
Use the a.b.c.d for for the ipaddress and 0-32 for ipwidth.
EOF
				read value
				if [ ! "$value" = "" ]; then
					if [ "$uaatt" = "ipaddress" ]; then
						fixipvalue
						echo New value is $value.
					fi
					mysql -u$emguser -p$emgpasswd -h$emghost -P$emgport $emgdb << EOF
update emguseraccess set $uaatt='$value' where useraccessid=$uaid
EOF
				fi
				;;
		esac
	done
}

showaccess()
{
	while true; do
		echo ========== ACCESS RIGHTS ========== 
		mysql -u$emguser -p$emgpasswd -h$emghost -P$emgport $emgdb << EOF
select useraccessid,connector,ipaddress,ipwidth from emguseraccess where userid=$userid\G
EOF
		cat << EOF
Enter useraccessid to edit, 'a' to add a new entry,
or 'q' to go back.
EOF
		read uaid
		case $uaid in
			a)
				echo Enter connector name.
				read cname
				if [ "$cname" = "" ]; then
					break
				fi
				echo Enter ipaddress.
				read value
				fixipvalue
				ipaddress=$value
				echo Enter ipwidth.
				read value
				ipwidth=$value
				mysql -u$emguser -p$emgpasswd -h$emghost -P$emgport $emgdb << EOF
insert into emguseraccess (userid, connector, ipaddress, ipwidth) values ($userid, '$cname', $ipaddress, $ipwidth);
EOF
				;;
			q)
				return
				;;
			*)
				editaccess
				;;
		esac
	done
}

showuser()
{
	while true; do
		echo ========== USER DETAILS ========== 
		mysql -u$emguser -p$emgpasswd -h$emghost -P$emgport $emgdb > result.log << EOF
select * from emguser where userid=$userid\G
EOF
		if [ -s result.log ]; then
			cat result.log
			cat << EOF
Enter attribute name to change, 'a' to show access rights,
'q' to go back, or 'del' to delete the user.
EOF
			read c
		else
			echo No such user.
			c=q
			break
		fi
		case $c in
			del)
				echo Deleting user $userid.
				mysql -u$emguser -p$emgpasswd -h$emghost -P$emgport $emgdb << EOF
delete from emguser where userid=$userid;
EOF
				return
				;;
			a)
				showaccess
				;;
			q)
				return
				;;
			*)
				echo Enter new value for $c for user $userid, or qqq to skip.
				read value
				case $value in
					qqq)
						;;
					*)
						echo Update emguser set $c=$value
						mysql -u$emguser -p$emgpasswd -h$emghost -P$emgport $emgdb << EOF
update emguser set $c="$value" where userid=$userid;
EOF
						if [ "$c" = "userid" ]; then
							userid=$value
						fi
						;;
				esac
				;;
		esac
	done
}


while true; do
	cat << EOF
EMG User Administration
 1. Show/edit users
 2. Add user
 q. Exit

Enter choice:
EOF
	read a
	case $a in
		1)
			mysql -u$emguser -p$emgpasswd -h$emghost -P$emgport $emgdb << EOF
select userid,username,fullname from emguser;
EOF
			cat << EOF
Enter userid to edit, q to go back.
EOF
			read userid
			case $userid in
				q)
					;;
				*)
					showuser
					;;
			esac
			;;
		2)
			echo Enter username:
			read name
			if [ ! "$name" = "" ]; then
				echo Enter password:
				read pw
#				echo The value of last_insert_id is the userid.
				userid=`mysql -u$emguser -p$emgpasswd -h$emghost -P$emgport $emgdb -B << EOF
insert into emguser (username, password) values ('$name', '$pw');
select LAST_INSERT_ID();
EOF`
				userid=`echo $userid | cut -d ' ' -f 2`
				showuser
			fi
			;;
		q)
			exit 0
	esac

done

exit 0

