
# -----------------------------------------------------------------------
# pb
# -----------------------------------------------------------------------
CREATE TABLE pb
(
                            pbid INTEGER NOT NULL AUTO_INCREMENT,
                    pbtype INTEGER NOT NULL,
                    pbname VARCHAR (60) NOT NULL,
                    username VARCHAR (20) NOT NULL,
    PRIMARY KEY(pbid),
    UNIQUE unique_pb_pbname (pbtype, pbname, username),
    INDEX idx_pb_username (username, pbtype)
) ENGINE=InnoDB;

# -----------------------------------------------------------------------
# pbentry
# -----------------------------------------------------------------------
CREATE TABLE pbentry
(
                            id INTEGER NOT NULL AUTO_INCREMENT,
                    pbid INTEGER NOT NULL,
                    company VARCHAR (60),
                    name VARCHAR (60),
                    destaddr CHAR (64) NOT NULL,
    PRIMARY KEY(id),
    UNIQUE unique_pbentry_all (pbid, company, name, destaddr)
) ENGINE=InnoDB;

# -----------------------------------------------------------------------
# routelog
# -----------------------------------------------------------------------
CREATE TABLE routelog
(
                    msgid BIGINT NOT NULL,
                    starttime DATETIME NOT NULL,
                    startsecs INTEGER NOT NULL,
                    startmsecs INTEGER NOT NULL,
                    endtime DATETIME,
                    endsecs INTEGER,
                    endmsecs INTEGER,
                    lastdlrsecs INTEGER,
                    lastdlrmsecs INTEGER,
                    npdus INTEGER,
                    charcode INTEGER,
                    status INTEGER NOT NULL,
                    bufferedstatus INTEGER,
                    msgtype INTEGER,
                    origid BIGINT,
                    charge_price_id INTEGER,
                    charge_cost_price_id INTEGER,
                    charge_reseller_price_id INTEGER,
                    sourceaddrton INTEGER (1),
                    sourceaddrnpi INTEGER (1),
                    destaddrton INTEGER (1),
                    destaddrnpi INTEGER (1),
                    dlrvalue INTEGER (1),
                    mcc INTEGER (1),
                    mnc INTEGER (1),
                    dlr_mcc INTEGER (1),
                    dlr_mnc INTEGER (1),
                    charge DECIMAL (8,4),
                    charge_cost DECIMAL (8,4),
                    charge_reseller DECIMAL (8,4),
                    username VARCHAR (20),
                    sourceaddr VARCHAR (64),
                    destaddr VARCHAR (64) NOT NULL,
                    reason VARCHAR (255),
                    reasontext VARCHAR (255),
                    note VARCHAR (255),
                    smscid VARCHAR (255),
                    inconnector VARCHAR (255) NOT NULL,
                    outconnector VARCHAR (255),
    PRIMARY KEY(msgid),
    INDEX idx_routelog_username (username),
    INDEX idx_routelog_starttime (starttime),
    INDEX idx_routelog_origid (origid)
) ENGINE=InnoDB;

# -----------------------------------------------------------------------
# connectorlog
# -----------------------------------------------------------------------
CREATE TABLE connectorlog
(
                            logid INTEGER NOT NULL AUTO_INCREMENT,
                    aclentrywhoid INTEGER,
                    aclentrywhereid INTEGER,
                    deltime INTEGER,
                    origid BIGINT,
                    serviceid INTEGER,
                    id BIGINT,
                    instance INTEGER,
                    smscop INTEGER NOT NULL,
                    scts DATETIME NOT NULL,
                    startsecs INTEGER,
                    startmsecs INTEGER,
                    endsecs INTEGER,
                    endmsecs INTEGER,
                    retcode INTEGER NOT NULL,
                    pduseq INTEGER,
                    pduseqmax INTEGER,
                    messagelen INTEGER default 0,
                    msgtype INTEGER,
                    qpriority INTEGER,
                    senderts INTEGER,
                    username VARCHAR (32),
                    vlr VARCHAR (32),
                    sourceaddr VARCHAR (64),
                    sourceaddrton INTEGER (1),
                    sourceaddrnpi INTEGER (1),
                    destaddr VARCHAR (64),
                    destaddrton INTEGER (1),
                    destaddrnpi INTEGER (1),
                    imsi VARCHAR (64),
                    reason VARCHAR (255) NOT NULL,
                    remoteip VARCHAR (80),
                    connector VARCHAR (255),
                    messageidin CHAR (255),
                    smscid CHAR (80),
    PRIMARY KEY(logid),
    INDEX idx_clog_connector (connector),
    INDEX idx_clog_id (id),
    INDEX idx_clog_sourceaddr (sourceaddr),
    INDEX idx_clog_destaddr (destaddr),
    INDEX idx_clog_username (username, smscop),
    INDEX idx_clog_scts (scts),
    INDEX idx_clog_smscop (smscop)
) ENGINE=InnoDB;

# -----------------------------------------------------------------------
# messageoption
# -----------------------------------------------------------------------
CREATE TABLE messageoption
(
                    id BIGINT NOT NULL,
                    optionkey INTEGER NOT NULL,
                    data VARCHAR (255) NOT NULL,
    INDEX idx_moption_id (id),
    INDEX idx_moption_key (optionkey)
) ENGINE=InnoDB;

# -----------------------------------------------------------------------
# messagebody
# -----------------------------------------------------------------------
CREATE TABLE messagebody
(
                    id BIGINT NOT NULL,
                    data LONGTEXT NOT NULL,
    PRIMARY KEY(id),
    INDEX idx_mbody (id)
) ENGINE=InnoDB;

# -----------------------------------------------------------------------
# emguser
# -----------------------------------------------------------------------
CREATE TABLE emguser
(
                            userid INTEGER NOT NULL AUTO_INCREMENT,
                    parent_id INTEGER,
                    creditssend INTEGER default 0,
                    creditssenddec INTEGER default 0,
                    creditsreceive INTEGER default 0,
                    maxsessions INTEGER,
                    throughput INTEGER,
                    lastlogin DATETIME,
                    lastfailedlogin DATETIME,
                    lastip BIGINT,
                    lastipstr VARCHAR (80),
                    lockeduntil DATETIME,
                    allowpostpaid INTEGER,
                    idletimeout INTEGER,
                    failedlogins INTEGER default 0,
                    username VARCHAR (20) NOT NULL,
                    password VARCHAR (20),
                    usergroup VARCHAR (20),
                    md5password CHAR (32),
                    fullname VARCHAR (64),
                    customerno VARCHAR (64),
                    email VARCHAR (80),
                    route VARCHAR (80),
                    routedlr VARCHAR (80),
                    routesat VARCHAR (80),
                    satpoolcreate VARCHAR (80),
                    routing VARCHAR (255),
                    clientconfig VARCHAR (255),
                    forcesourceaddr VARCHAR (64),
                    created DATETIME,
                    company VARCHAR (64),
                    phone VARCHAR (80),
                    extra1 VARCHAR (255),
                    extra2 VARCHAR (255),
                    extra3 VARCHAR (255),
                    extra4 VARCHAR (255),
                    extra5 VARCHAR (255),
                    extra6 VARCHAR (255),
                    extra7 VARCHAR (255),
                    extra8 VARCHAR (255),
                    extra9 VARCHAR (255),
                    charges VARCHAR (255),
                    charge_balance DECIMAL (13,4),
                    charge_balance_postpaid_limit DECIMAL (13,4),
                    mode VARCHAR (64),
                    cert_fingerprint VARCHAR (40),
                    min_vp INTEGER,
                    max_vp INTEGER,
                    dlr_delay DECIMAL (4,3),
                    expires_at DATETIME,
                    crypt_password VARCHAR (255),
    PRIMARY KEY(userid),
    UNIQUE unique_user_username (username),
    INDEX idx_user_username (username)
) ENGINE=InnoDB;

# -----------------------------------------------------------------------
# emguseraccess
# -----------------------------------------------------------------------
CREATE TABLE emguseraccess
(
                            useraccessid INTEGER NOT NULL AUTO_INCREMENT,
                    userid INTEGER NOT NULL,
                    ipaddress BIGINT,
                    ipstr VARCHAR (80),
                    ipwidth INTEGER,
                    connector VARCHAR (255) NOT NULL,
    PRIMARY KEY(useraccessid),
    INDEX idx_useraccess_userid (userid, connector)
) ENGINE=InnoDB;

# -----------------------------------------------------------------------
# emgsystem
# -----------------------------------------------------------------------
CREATE TABLE emgsystem
(
                    keyname VARCHAR (255) NOT NULL,
                    value VARCHAR (255) NOT NULL,
    UNIQUE idx_emgsystem_keyname (keyname)
) ENGINE=InnoDB;

# -----------------------------------------------------------------------
# monthlysummary
# -----------------------------------------------------------------------
CREATE TABLE monthlysummary
(
                            id INTEGER NOT NULL AUTO_INCREMENT,
                    month CHAR (7) NOT NULL,
                    userid INTEGER NOT NULL,
                    count INTEGER NOT NULL,
                    charge DECIMAL (13,4),
                    charge_cost DECIMAL (13,4),
    PRIMARY KEY(id),
    INDEX idx_monthlysummary_userid (userid),
    INDEX idx_monthlysummary_month (month)
) ENGINE=InnoDB;

# -----------------------------------------------------------------------
# pdulog
# -----------------------------------------------------------------------
CREATE TABLE pdulog
(
                            id INTEGER NOT NULL AUTO_INCREMENT,
                    created DATETIME NOT NULL,
                    msecs SMALLINT NOT NULL,
                    rw CHAR (1) NOT NULL,
                    connector VARCHAR (255) NOT NULL,
                    instance SMALLINT NOT NULL,
                    operation VARCHAR (255),
                    status INTEGER,
                    trn INTEGER,
                    pdu VARCHAR (20000) NOT NULL,
    PRIMARY KEY(id),
    INDEX idx_pdulog_created (created),
    INDEX idx_pdulog_connector (connector)
) ENGINE=InnoDB;

# -----------------------------------------------------------------------
# cfg_connectors
# -----------------------------------------------------------------------
CREATE TABLE cfg_connectors
(
                            id INTEGER NOT NULL AUTO_INCREMENT,
                    name VARCHAR (60),
                    connector_order INTEGER,
                    updated DATETIME NOT NULL,
                    disabled TINYINT default 0 NOT NULL,
                    note VARCHAR (20000),
    PRIMARY KEY(id),
    UNIQUE unique_connector_name (name)
) ENGINE=InnoDB;

# -----------------------------------------------------------------------
# cfg_connectoroptions
# -----------------------------------------------------------------------
CREATE TABLE cfg_connectoroptions
(
                            id INTEGER NOT NULL AUTO_INCREMENT,
                    connectorid INTEGER NOT NULL,
                    keyorder INTEGER,
                    disabled TINYINT default 0 NOT NULL,
                    keyname VARCHAR (255) NOT NULL,
                    value VARCHAR (255),
                    updated DATETIME NOT NULL,
                    note VARCHAR (20000),
    PRIMARY KEY(id)
) ENGINE=InnoDB;

# -----------------------------------------------------------------------
# cfg_general
# -----------------------------------------------------------------------
CREATE TABLE cfg_general
(
                            id INTEGER NOT NULL AUTO_INCREMENT,
                    keyorder INTEGER,
                    keyname VARCHAR (255) NOT NULL,
                    value VARCHAR (255),
                    updated DATETIME NOT NULL,
    PRIMARY KEY(id)
) ENGINE=InnoDB;

# -----------------------------------------------------------------------
# cfg_plugins
# -----------------------------------------------------------------------
CREATE TABLE cfg_plugins
(
                            id INTEGER NOT NULL AUTO_INCREMENT,
                    name VARCHAR (60),
                    updated DATETIME NOT NULL,
                    instances INTEGER default 0,
                    offset INTEGER default 0,
                    disabled TINYINT default 0 NOT NULL,
                    dbprofile VARCHAR (64),
                    library VARCHAR (1024),
                    config VARCHAR (1024),
                    note VARCHAR (16000),
    PRIMARY KEY(id),
    UNIQUE unique_plugin_name (name)
) ENGINE=InnoDB;

# -----------------------------------------------------------------------
# cfg_satpools
# -----------------------------------------------------------------------
CREATE TABLE cfg_satpools
(
                            id INTEGER NOT NULL AUTO_INCREMENT,
                    name VARCHAR (60),
                    updated DATETIME NOT NULL,
                    threaded SMALLINT,
                    quoted_reply SMALLINT,
                    ignore_destaddr SMALLINT,
                    random SMALLINT,
                    expire INTEGER,
                    disabled TINYINT default 0 NOT NULL,
                    softfail TINYINT default 0,
                    addressrange VARCHAR (1024),
                    note VARCHAR (20000),
    PRIMARY KEY(id),
    UNIQUE unique_satpool_name (name)
) ENGINE=InnoDB;
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
INSERT INTO emgsystem SELECT 'emgschema', 44 FROM DUAL WHERE NOT EXISTS ( SELECT 1 FROM emgsystem WHERE keyname = 'emgschema' );
